%   This is the class file `TNThesis.cls', version 5.0.1 (aka 'Mike')
%   for the creation of masters' theses and doctoral dissertations
%   in the sciences and engineering at Tennessee Tech University.

%   Maintained by Dr. Andrew J. Hetzel,
%   Department of Mathematics,
%   Tennessee Tech University,
%   ahetzel@tntech.edu

%   Last modified 2023/01/13

%   Copyright 2022 Andrew. J. Hetzel

%   This work may be distributed and/or modified under the
%   conditions of the LaTeX Project Public License, either version 1.3
%   of this license or (at your option) any later version.
%   The latest version of this license is in
%       http://www.latex-project.org/lppl.txt
%   and version 1.3 or later is part of all distributions of LaTeX
%   version 2005/12/01 or later.

%   This work has the LPPL maintenance status `maintained'.

%   The Current Maintainer of this work is Andrew J. Hetzel.

%   This work consists of the files TNThesis.cls and TNTmain.tex

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{TNThesis}[06.11.2022 LaTeX class file for %
	TN Tech science theses and dissertations, v. 'Mike' 5.0.1]
    \newif\if@tnt@usetikz@
        \@tnt@usetikz@false
    \DeclareOption{tikz}{\global\@tnt@usetikz@true}


%       package and memoir class loading

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{memoir}}
    \ProcessOptions\relax
\LoadClass[oldfontcommands, twoside, extrafontsizes, 12pt]{memoir}


\RequirePackage{lmodern}
\RequirePackage{microtype}
\RequirePackage[american]{babel}
\RequirePackage[utf8]{inputenc}
\RequirePackage[T1]{fontenc}

\RequirePackage[autostyle=true]{csquotes}
\RequirePackage{ragged2e}

\RequirePackage{amsfonts, amssymb, amsthm, latexsym, mathtools}
    \mathtoolsset{mathic}
\RequirePackage{mathrsfs}
\RequirePackage{textcomp}

\RequirePackage[cache=false, newfloat]{minted}

\RequirePackage{interval}
    \intervalconfig{soft open fences}
\RequirePackage{bigdelim, bigstrut, colortbl, multirow}
\RequirePackage{centernot}

\RequirePackage{thmtools}
\RequirePackage{enumitem}
    \setlist[description]{left=\parindent}
    \setlist[enumerate]{left=\parindent}
    \setlist[itemize]{left=\parindent}

\RequirePackage{xcolor, graphicx}

\if@tnt@usetikz@
    \RequirePackage{tikz}
        \usetikzlibrary{cd}
        \usetikzlibrary{decorations.pathmorphing}
        \usetikzlibrary{babel}
\fi

\RequirePackage{totcount}
\RequirePackage{url}
\RequirePackage{cleveref}


%       command and control

%   general
\newdimen\tnt@parindent
    \tnt@parindent3em

%   title page
\newdimen\tnt@max@lineindent
    \tnt@max@lineindent2em
\newdimen\tnt@max@linestep
    \tnt@max@linestep3em
\newdimen\tnt@linestep@increment
    \tnt@linestep@increment1em
\newdimen\tnt@lineindent@increment
    \tnt@lineindent@increment1em
\newcount\tnt@title@hyphenpenalty
    \tnt@title@hyphenpenalty10

%   approval page
\newdimen\tnt@comember@liststd
    \tnt@comember@liststd1.9in
\newdimen\tnt@signature@linewd
    \tnt@signature@linewd4.5in

%   floats
\newskip\tnt@textfloatsep
    \tnt@textfloatsep1\onelineskip plus 0.5\onelineskip minus 0.5\onelineskip
\newskip\tnt@intextsep
    \tnt@textfloatsep1\onelineskip plus 0.5\onelineskip minus 0.5\onelineskip
\newskip\tnt@floatsep
    \tnt@floatsep1\onelineskip plus 0.5\onelineskip minus 0.5\onelineskip
\def\tnt@floatpagefrac{0.7}
\def\tnt@textfrac{0.2}
\def\tnt@topfrac{0.7}
\def\tnt@bottomfrac{0.3}
\def\tnt@minted@numberfont#1{%
    \sffamily%
    \footnotesize%
    \oldstylenums{%
            #1%
        }%
}
\newdimen\tnt@minted@numbersep
    \tnt@minted@numbersep1em

%   table of contents/list pages
\newdimen\tnt@std@pgboxwidth
    \tnt@std@pgboxwidth5em
\newdimen\tnt@spc@pgboxwidth
    \tnt@spc@pgboxwidth7em
\newif\if@tnt@single@spacing@
    \@tnt@single@spacing@true

%   chapter and friends
\newskip\tnt@chapskip
    \tnt@chapskip0ex plus 1ex minus 1ex
\newskip\tnt@secbeforeskip
    \tnt@secbeforeskip2ex plus 1ex minus .25ex
\newskip\tnt@secafterskip
    \tnt@secafterskip1ex plus .5ex

%   bibliography
\newdimen\tnt@labelwidth
    \tnt@labelwidth\tnt@parindent

%   theorem and friends
\newskip\tnt@displayaboveskip
    \tnt@displayaboveskip2ex plus 1ex minus 1ex
 \newskip\tnt@displaybelowskip
    \tnt@displaybelowskip2ex plus 1ex minus 1ex
 \newskip\tnt@displayshortaboveskip
    \tnt@displayshortaboveskip1.5ex plus 0.5ex minus 0.5ex
 \newskip\tnt@displayshortbelowskip
    \tnt@displayshortbelowskip1.5ex plus 0.5ex minus 0.5ex
 \newskip\tnt@abovethm
    \tnt@abovethm2ex plus 1ex minus 1ex
 \newskip\tnt@belowthm
    \tnt@belowthm2ex minus 1ex


 %      general macros

 \def\concatenate#1#2{%
    \expandafter\xdef\expandafter#1\expandafter{#1#2}
}

\def\xifsame#1#2#3#4{%
    \edef\@tempa{%
        \noexpand\detokenize{#1}
    }
    \edef\@tempb{%
        \noexpand\detokenize{#2}
    }
    \ifx\@tempa\@tempb%
        #3%
    \else%
        #4%
    \fi
}

\def\addtolist#1#2{%
    \xifsame{#1}{}{%
        \xdef#1{\zap@space#2 \@empty}%
    }{%
        \xdef#1{\zap@space#1,#2 \@empty}%
    }
}

\def\@firstofthree#1#2#3{#1}
\def\@secondofthree#1#2#3{#2}


%       global text spacing adjustments

\DoubleSpacing
\midsloppy
\hfuzz2.62pt
\vfuzz2.62pt


%       global demerit and penalty parameters

\doublehyphendemerits100000
\brokenpenalty10000
\widowpenalty10000
\clubpenalty10000


%       global page layout parameters

\paperwidth8.5in
\paperheight11in
\foremargin1.0in
\spinemargin1.5in
\textwidth6.0in

\newcommand*{\LineJump}[1]{%
    \vspace*{#1\baselineskip}
}
\headheight\baselineskip
\headsep0ex

\uppermargin1in
    \addtolength{\uppermargin}{-\topskip}
\lowermargin1in

\textheight\paperheight
    \addtolength{\textheight}{-\uppermargin}
    \addtolength{\textheight}{-\lowermargin}

\footskip2\onelineskip

\parindent\tnt@parindent

\checkandfixthelayout[nearest]

\makepagestyle{tech}
    \makeevenfoot{tech}{}{\thepage}{}
    \makeoddfoot{tech}{}{\thepage}{}


%       title formatting section

\edef\newinnerdimen{\noexpand\newdimen}

\newdimen\tnt@fittedwidth
\newdimen\tnt@naturalwidth
\newdimen\tnt@deformation
\newdimen\tnt@prevdepth
\newdimen\tnt@lineindent
\newdimen\tnt@linestep

\newcount\tnt@penalty
\newcount\tnt@looseness
\newcount\tnt@linedemerit
\newcount\tnt@totalnumber@linedemerits
\newcount\tnt@savedpenalty
\newcount\tnt@linecount
\newcount\tnt@min@totalnumber@linedemerits
    \tnt@min@totalnumber@linedemerits100000000
\newcount\tnt@maxnumber@titlelines

\newskip\tnt@savedskip

\newbox\tnt@linebox
\newbox\tnt@parabox
\newbox\tnt@temp@sglspace@title
\newbox\tnt@temp@dblspace@title
\newbox\tnt@final@sglspace@title
\newbox\tnt@final@dblspace@title

\newif\if@tnt@incompatiblelines@
\newif\if@tnt@doublehyphens@

\def\tnt@LineDemeritAssessment#1#2{%
    \count@\numexpr\linepenalty+#1\relax
    \@tempcnta\numexpr\count@*\count@\relax
    \@tempcntb\numexpr#2*#2\relax
    \ifnum-1<#2
        \tnt@linedemerit\numexpr\@tempcnta+\@tempcntb\relax
    \else\ifnum-10000<#2
        \tnt@linedemerit\numexpr\@tempcnta-\@tempcntb\relax
        \else
            \tnt@linedemerit\@tempcnta
        \fi
    \fi
    \global\advance\tnt@totalnumber@linedemerits by \tnt@linedemerit
}

\def\tnt@AdjDemeritsAssessment#1#2{%
    \@tempcnta\tnt@looseness
    \ifnum#1<13
        \tnt@looseness\tw@
    \else\ifdim#2<0pt
        \tnt@looseness\thr@@
        \else\ifnum#1<100
            \tnt@looseness\@ne
            \else
                \tnt@looseness\z@
            \fi
        \fi
    \fi
    \ifnum\numexpr\@tempcnta-\tnt@looseness\relax>1
        \global\@tnt@incompatiblelines@true
    \fi
    \ifnum\numexpr\tnt@looseness-\@tempcnta\relax<-1
        \global\@tnt@incompatiblelines@true
    \fi
}

\def\tnt@HyphenPenaltyAssessment#1{% only works if \brokenpenalty is nonzero
    % and \hyphenpenalty=\exhyphenpenalty is nonzero
    \begingroup
        \count@\tnt@penalty
        \hyphenpenalty\tnt@title@hyphenpenalty
        \exhyphenpenalty\hyphenpenalty
        \brokenpenalty10000
        \ifnum#1=\brokenpenalty
            \global\tnt@penalty\hyphenpenalty
        \else
            \global\tnt@penalty\z@
        \fi
        \ifnum\count@=\tnt@penalty
            \ifnum\tnt@penalty=\hyphenpenalty
                \global\@tnt@doublehyphens@true
            \fi
        \fi
    \endgroup
}

\def\tnt@AssessLineBox#1{%
    \setbox0\hb@xt@\wd#1{\unhcopy#1}
    \global\tnt@fittedwidth\wd0
    \setbox0\hbox{\unhcopy#1}
    \tnt@naturalwidth\wd0
    \tnt@deformation\dimexpr\tnt@fittedwidth-\tnt@naturalwidth\relax
    \tnt@LineDemeritAssessment{\badness}{\tnt@penalty}
    \tnt@HyphenPenaltyAssessment{\tnt@savedpenalty}
    \tnt@AdjDemeritsAssessment{\badness}{\tnt@deformation}
}

\def\tnt@ExtraDemeritsAssessment{%
    \if@tnt@incompatiblelines@%
        \global\advance\tnt@totalnumber@linedemerits by \adjdemerits
    \fi
    \if@tnt@doublehyphens@%
        \global\advance\tnt@totalnumber@linedemerits by \doublehyphendemerits
    \fi
}

\def\tnt@DissectTitle#1\par{%
    \tnt@prevdepth\prevdepth%
    \global\setbox\tnt@temp@dblspace@title\vbox{%
        \setbox0\vbox{%
            \hbox{\vrule depth \tnt@prevdepth}%
            \linespread{2.0}\selectfont%
            #1\par\tnt@dblspace@assesstitle%
        }%
        \unvbox\tnt@parabox%
    }%
    \global\setbox\tnt@temp@sglspace@title\vbox{%
        \setbox0\vbox{%
            \hbox{\vrule depth \tnt@prevdepth}%
            \linespread{1.0}\selectfont%
            #1\par\tnt@sglspace@assesstitle%
        }%
        \unvbox\tnt@parabox%
    }%
}

\def\tnt@sglspace@assesstitle{%
    \loop
        \setbox\tnt@linebox\lastbox
        \tnt@savedskip\lastskip\unskip
        \tnt@savedpenalty\lastpenalty\unpenalty
        \ifvoid\tnt@linebox\else
            \tnt@AssessLineBox\tnt@linebox
            \setbox0\hb@xt@\textwidth{\hfill\hb@xt@\tnt@fittedwidth
                {\unhcopy\tnt@linebox}\hfill}
            \global\setbox\tnt@parabox\vbox{%
                \penalty\tnt@savedpenalty
                \vskip\tnt@savedskip
                \box0
                \unvbox\tnt@parabox
            }
    \repeat
    \tnt@ExtraDemeritsAssessment
}

\def\tnt@dblspace@assesstitle{%
    \loop
        \setbox\tnt@linebox\lastbox
        \tnt@savedskip\lastskip\unskip
        \tnt@savedpenalty\lastpenalty\unpenalty
        \ifvoid\tnt@linebox\else
            \tnt@fittedwidth\wd\tnt@linebox
            \setbox0\hb@xt@\textwidth{\hfill\hb@xt@\tnt@fittedwidth
                {\unhcopy\tnt@linebox}\hfill}
            \global\setbox\tnt@parabox\vbox{%
                \penalty\tnt@savedpenalty
                \vskip\tnt@savedskip
                \box0
                \unvbox\tnt@parabox
            }
    \repeat
}

\def\tnt@TitleCompare#1#2{%
    \ifnum#1<#2
        \global\tnt@min@totalnumber@linedemerits#1
        \global\setbox\tnt@final@sglspace@title\vbox{%
            \unvbox\tnt@temp@sglspace@title
        }
        \global\setbox\tnt@final@dblspace@title\vbox{%
            \unvbox\tnt@temp@dblspace@title
        }
    \else
        \@gobble\tnt@temp@sglspace@title
        \@gobble\tnt@temp@dblspace@title
    \fi
}

\begingroup
    \count@\z@
    \loop
        \ifdim\dimexpr\tnt@max@lineindent+\the\count@\tnt@max@linestep\relax>%
            \dimexpr\textwidth/2\relax\else
            \global\tnt@maxnumber@titlelines\count@
            \advance\count@\@ne
    \repeat
\endgroup

\def\tnt@parshape#1#2#3{%
    \@tempcnta\z@
    \def\tnt@parshapelist{}
    \@tempdima#2%
    \@tempdimb#3%
    \loop
        \ifnum\@tempcnta>#1\else
            \@tempcntb\numexpr2*\@tempcnta\relax%
            \concatenate\tnt@parshapelist{%
                \dimexpr\@tempdima+\the\@tempcnta\@tempdimb\relax %
                \dimexpr\textwidth-2\@tempdima-\the\@tempcntb\@tempdimb\relax
            }
            \advance\@tempcnta\@ne
    \repeat
    \parshape \the\@tempcnta\space \tnt@parshapelist
}

\def\tnt@InvPyrmdShape#1#2#3{%
        \parindent0em
        \leftskip0pt plus0.5fil
        \rightskip0pt plus-0.5fil
        \parfillskip0pt plus1fil
        \tnt@parshape{\tnt@maxnumber@titlelines}{#1}{#2}%
            \textbf{\boldmath\MakeTextUppercase{#3}}
}

\def\tnt@FindBestTitle#1{%
    \begingroup
        \overfullrule0em
        \hbadness1000000
        \hfuzz\maxdimen
        \clubpenalty0
        \widowpenalty0
        \tnt@lineindent0em
        \loop
            \ifdim\tnt@lineindent>\tnt@max@lineindent\else
                \tnt@linestep1em
                {%
                    \loop
                        \ifdim\tnt@linestep>\tnt@max@linestep\else
                            \global\tnt@penalty\z@
                            \global\tnt@looseness\tw@
                            \global\@tnt@incompatiblelines@false
                            \global\@tnt@doublehyphens@false
                            \global\tnt@totalnumber@linedemerits\z@
                            \tnt@DissectTitle%
                                \tnt@InvPyrmdShape{\tnt@lineindent}{\tnt@linestep}{#1}\par
                            \tnt@TitleCompare%
                                {\tnt@totalnumber@linedemerits}{\tnt@min@totalnumber@linedemerits}
                            \advance\tnt@linestep by \tnt@linestep@increment\relax
                    \repeat
                }
                \advance\tnt@lineindent by \tnt@lineindent@increment\relax
        \repeat
    \endgroup
}


%       special macros for the frontmatter

\newcommand*{\ThesisTitle}[1]{%
    \def\tnt@raw@title{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@raw@title}{%
        \ClassWarningNoLine{TNT}{%
            Title has not been provided through\MessageBreak
            the \protect\ThesisTitle\space macro%
        }
        \tnt@FindBestTitle{%
            \textlangle\textlangle Title Not Provided\textrangle\textrangle%
        }
    }{%
        \tnt@FindBestTitle{\tnt@raw@title}
    }
}

\newcommand*{\ThesisAuthor}[1]{%
    \def\tnt@author{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@author}{%
        \ClassWarningNoLine{TNT}{%
            Author has not been provided through\MessageBreak
            the \protect\ThesisAuthor\space macro%
        }
        \def\tnt@author{%
            \textlangle\textlangle Name Not Provided\textrangle\textrangle%
        }
    }{}
}

\newcommand*{\DocumentType}[1]{%
    \def\tnt@doctype{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@doctype}{%
        \ClassWarningNoLine{TNT}{%
            Document type has not been provided through\MessageBreak
            the \protect\DocumentType\space macro%
        }
        \def\tnt@doctype{%
            \textlangle\textlangle Document Type Not Provided\textrangle\textrangle%
        }
    }{}
}

\newcommand*{\DegreeType}[1]{%
    \def\tnt@degreetype{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@degreetype}{%
        \ClassWarningNoLine{TNT}{%
            Degree type has not been provided through\MessageBreak
            the \protect\DegreeType\space macro%
        }
        \def\tnt@degreetype{%
            \textlangle\textlangle Degree Type Not Provided\textrangle\textrangle%
        }
    }{}
}

\newcommand*{\Major}[1]{%
    \def\tnt@major{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@major}{%
        \ClassWarningNoLine{TNT}{%
            Major has not been provided though\MessageBreak
            the \protect\Major\space macro%
        }
        \def\tnt@major{%
            \textlangle\textlangle Major Not Provided\textrangle\textrangle%
        }
    }{}
}

\newcommand*{\GraduationMonth}[1]{%
    \def\tnt@gradmonth{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@gradmonth}{%
        \ClassWarningNoLine{TNT}{%
            Graduation month has not been provided through\MessageBreak
            the \protect\GraduationMonth\space macro%
        }
        \def\tnt@gradmonth{May}
    }{}
}

\newcommand*{\GraduationYear}[1]{%
    \def\tnt@gradyear{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@gradyear}{%
        \ClassWarningNoLine{TNT}{%
            Graduation year has not been provided through\MessageBreak
            the \protect\GraduationYear\space macro%
        }
        \def\tnt@gradyear{\the\year}
    }{}
}

\newcommand*{\ThesisAbstract}[1]{%
    \long\def\tnt@abstract{%
        \input{#1}
    }
}
\AtBeginDocument{%
    \@ifundefined{tnt@abstract}{%
        \ClassWarningNoLine{TNT}{%
            Abstract has not been provided through\MessageBreak
            the \protect\ThesisAbstract\space macro%
        }
        \def\tnt@abstract{%
            \textlangle\textlangle Abstract Not Provided\textrangle\textrangle%
        }
    }{}
}

\newcommand*{\CopyrightOwner}[1]{%
    \def\tnt@copyowner{#1}
}
\AtBeginDocument{%
    \@ifundefined{tnt@copyowner}{%
        \def\tnt@copyowner{%
            \tnt@author%
        }
    }{}
}

\newcount\tnt@totalnumber@members
    \tnt@totalnumber@members\z@
\begingroup
    \count@\@ne
    \loop
        \ifnum\count@>9\else
            \expandafter\def\csname
            tnt@committee@member\the\count@\endcsname{}
            \advance\count@\@ne
    \repeat
\endgroup
\newcommand*{\CommitteeMember}[2]{%
    \expandafter\def\csname tnt@committee@member#1\endcsname{%
        \parbox[t]{\tnt@signature@linewd}{%
            \rule{\tnt@signature@linewd}{0.5pt}\vskip0ex%
            #2\hfill Date\hspace*{0.25in}%
        }\\%
    }
    \global\advance\tnt@totalnumber@members\@ne
}

\AtBeginDocument{%
    \ifnum\tnt@totalnumber@members=\z@
        \ClassWarningNoLine{TNT}{%
            Committee members' names have not been provided through\MessageBreak
            the \protect\CommitteeMember\space macro%
        }
        \expandafter\def\csname tnt@committee@member1\endcsname{%
            \textlangle\textlangle Committee Member Not
            Provided\textrangle\textrangle%
        }
        \global\advance\tnt@totalnumber@members\@ne
    \fi
}

\newcommand{\Dedication}[1]{%
    \long\def\tnt@dedication{#1}
}

\newcommand{\Acknowledgments}[1]{%
    \long\def\tnt@acknowledgment{%
        \input{#1}
    }
}


%       special macros for the mainmatter

\newcount\tnt@totalnumber@chapters
    \tnt@totalnumber@chapters\z@
\newcommand*{\MyChapter}[2]{%
    \expandafter\def\csname tnt@mychapter#1\endcsname{%
        \input{#2}
    }
    \global\advance\tnt@totalnumber@chapters\@ne
}
\IfFileExists{nullchapter}{}{%
\begin{filecontents}{nullchapter}
    \chapter{\textlangle\textlangle Chapter Not Provided\textrangle\textrangle}
\end{filecontents}
}
\expandafter\def\csname tnt@mychapter0\endcsname{%
    \input{nullchapter}
}
\AtBeginDocument{%
    \ifnum\tnt@totalnumber@chapters=\z@
        \ClassWarningNoLine{TNT}{%
            A chapter has not been provided through\MessageBreak
            the \protect\MyChapter\space macro%
        }
    \fi
}


%       special macros for the backmatter

\newcount\tnt@totalnumber@appendices
    \tnt@totalnumber@appendices\z@
\newcommand*{\MyAppendix}[2]{%
    \expandafter\def\csname tnt@myappendix#1\endcsname{%
        \input{#2}
    }
    \global\advance\tnt@totalnumber@appendices\@ne
}

\newcommand*{\MyBibReferences}[1]{%
    \def\tnt@bibreferences{#1}
    \addbibresource{#1.bib}
}

\newcommand*{\MyVita}[1]{%
    \long\def\tnt@vita{%
        \input{#1}
    }
}
\AtBeginDocument{%
    \@ifundefined{tnt@vita}{%
        \ClassWarningNoLine{TNT}{%
            Your vita has not been provided through\MessageBreak
            the \protect\MyVita\space macro%
        }
        \def\tnt@vita{%
            \textlangle\textlangle Vita Not Provided\textrangle\textrangle%
        }
    }{}
}


\strictpagecheck\checkoddpage


%       title page

\long\def\tnt@titlepage{%
    \thispagestyle{empty}
    \centering
    \begin{minipage}[c][9in]{6in}
       \centering
        \unvcopy\tnt@final@dblspace@title
        \LineJump{1}
        \vfill
        \rule{2in}{0.5pt}
        \vfill
        A \tnt@doctype \\
        Presented to \\
        the Faculty of the College of Graduate Studies \\
        Tennessee Technological University \\
        by \\
        \tnt@author
        \vfill
        \rule{2in}{0.5pt}
        \vfill
        In Partial Fulfillment \\
        of the Requirements of the Degree \\
        \MakeTextUppercase{\tnt@degreetype} \\
        \tnt@major
        \vfill
        \rule{2in}{0.5pt}
        \vfill
        \tnt@gradmonth\ \tnt@gradyear
    \end{minipage}
    \clearpage
}


%       abstract page

\long\def\tnt@abstractpage{%
    \cleartorecto
    \centering
    \begin{SingleSpace}
        \textbf{AN ABSTRACT OF A \MakeTextUppercase{\tnt@doctype}} \\
         \LineJump{1}
        \unvcopy\tnt@final@sglspace@title
        \LineJump{1}
        \tnt@author \\
        \LineJump{1}
        \tnt@degreetype\ in \tnt@major \\
        \LineJump{2}
        \begin{minipage}{6in}
            \parindent\tnt@parindent
            \tnt@abstract
        \end{minipage}
    \end{SingleSpace}
    \clearpage
}


%       copyright page

\long\def\tnt@copyrightpage{%
    \clearpage
    \centering
    \begin{minipage}[c][9in]{6in}
       \centering
        Copyright \copyright \thinspace \tnt@copyowner, \tnt@gradyear
    \end{minipage}
    \clearpage
}


%       approval page

\newdimen\tnt@member@vspace
\def\tnt@process@membersep#1{%
    \global\tnt@member@vspace\dimexpr\tnt@comember@liststd/#1\relax
}
\long\def\tnt@approvalpage{%
    \clearpage
    \phantomsection
    \addcontentsline{toc}{chapter}{Certificate of Approval}
    \enlargethispage{\baselineskip}
    \centering
    \textbf{CERTIFICATE OF APPROVAL OF
        \MakeTextUppercase{\tnt@doctype}}\\
    \LineJump{0.5}
    \unvcopy\tnt@final@dblspace@title
    by\\
    \tnt@author\\
    \LineJump{0.5}
    \raggedright
    \begin{minipage}{\tnt@signature@linewd}
        \SingleSpacing
        \noindent Graduate Advisory Committee:\\
        \tnt@process@membersep\tnt@totalnumber@members
        \setlength{\extrarowheight}{\tnt@member@vspace}
        \begin{tabular}{@{} p{\tnt@signature@linewd} @{}}
            \csname tnt@committee@member1\endcsname
            \csname tnt@committee@member2\endcsname
            \csname tnt@committee@member3\endcsname
            \csname tnt@committee@member4\endcsname
            \csname tnt@committee@member5\endcsname
            \csname tnt@committee@member6\endcsname
            \csname tnt@committee@member7\endcsname
            \csname tnt@committee@member8\endcsname
            \csname tnt@committee@member9\endcsname
        \end{tabular}
        \LineJump{2}
        \parbox[t]{\tnt@signature@linewd}{%
            Approved for the Faculty:\\
            \LineJump{1}\\
            \rule{\tnt@signature@linewd}{0.5pt}\vskip0ex
            Mark Stephens, Dean\hfill Date\hspace*{0.25in}\\
            College of Graduate Studies%
        }
    \end{minipage}
    \clearpage
}


%       dedication page

\long\def\tnt@dedicationpage{%
    \clearpage
    \phantomsection
    \addcontentsline{toc}{chapter}{Dedication}
    \centering
    \begin{minipage}[c][9in]{5in}
            \centering
            \textbf{DEDICATION} \\
            \LineJump{1}
            \tnt@dedication
    \end{minipage}
    \clearpage
}


%       acknowledgments page

\long\def\tnt@acknowledgmentspage{%
    \clearpage
    \phantomsection
    \addcontentsline{toc}{chapter}{Acknowledgments}
    \begin{center}
        \textbf{ACKNOWLEDGMENTS}
    \end{center}
    \LineJump{1}
    \begin{minipage}{6in}
        \parindent\tnt@parindent
        \tnt@acknowledgment
    \end{minipage}
    \clearpage
}


%       table of contents

\settocdepth{subsubsection}
\setsecnumdepth{subsubsection}

\addtodef{\tableofcontents*}{%
    \clearpage
    \if@tnt@single@spacing@\SingleSpacing\fi
    }{
    \clearpage
    \DoubleSpacing
}
\addto{\captionsamerican}{%
    \renewcommand*{\contentsname}{Table of Contents}
}

\renewcommand{\printtoctitle}[1]{%
    \centering
    \textbf{\MakeTextUppercase{#1}}
}
\renewcommand*{\tocheadstart}{%
    \if@tnt@single@spacing@\LineJump{-0.5}\else\LineJump{-0.25}\fi
    \par
}
\renewcommand*{\aftertoctitle}{%
    \if@tnt@single@spacing@\LineJump{0.5}\else\LineJump{0.25}\fi
    \par
}
\renewcommand*{\cftchapterfont}{\normalfont}
\renewcommand*{\cftchaptername}{Chapter\space}
\renewcommand*{\cftappendixname}{Appendix\space}
\renewcommand*{\cftchapteraftersnum}{:}
\renewcommand*{\cftchapterpagefont}{\normalfont}
\renewcommand*{\cftchapterleader}{%
    \cftchapterfont
    \cftdotfill{\cftchapterdotsep}
}
\renewcommand*{\cftchapterdotsep}{\cftnodots}
\cftbeforechapterskip\f@baselineskip
\renewcommand*{\insertchapterspace}{}
\renewcommand{\@tocrmarg}{4em plus1fil}

\renewcommand*{\cftsectiondotsep}{\cftnodots}
\cftbeforesectionskip\f@baselineskip

\renewcommand*{\cftsubsectiondotsep}{\cftnodots}
\cftbeforesubsectionskip\f@baselineskip

\renewcommand*{\cftsubsubsectiondotsep}{\cftnodots}
\cftbeforesubsubsectionskip\f@baselineskip


%       float placement and indexing

\newfloat{@Figure}{lof}{Figure}
\newfloat{@Table}{lot}{Table}
\newfloat{@Listing}{lol}{Listing}

\setFloatBlockFor{subsubsection}
\setFloatBlockFor{subsection}
\setFloatBlockFor{section}
\setFloatBlockFor{chapter}

\@fptop0ex

\textfloatsep\tnt@textfloatsep
\intextsep\tnt@textfloatsep
\floatsep\tnt@floatsep
\renewcommand{\bottomfraction}{\tnt@bottomfrac}
\renewcommand{\topfraction}{\tnt@topfrac}
\renewcommand{\textfraction}{\tnt@textfrac}
\renewcommand{\floatpagefraction}{\tnt@floatpagefrac}

\counterwithout{figure}{chapter}
\counterwithout{table}{chapter}
\counterwithout{listing}{chapter}

\regtotcounter{figure}
\regtotcounter{table}
\regtotcounter{listing}

\def\tnt@floats{%
    figure,@Figure,table,@Table,listing,@Listing%
}
\@for\type:=\tnt@floats\do{%
    \setfloatlocations{\type}{htbp}
    \setfloatadjustment{\type}{%
        \SingleSpacing
        \raggedright
    }
}

\renewcommand\@memfront@floats{}
\renewcommand\@memmain@floats{}
\renewcommand\@memback@floats{}


%       caption specifications

\captionnamefont{%
    \bfseries
    \raggedright
}
\captiontitlefont{%
    \itshape
}
\captiondelim{\newline\newline}
\captionstyle{\raggedright}
\belowcaptionskip1.5\onelineskip plus 0.5\onelineskip minus 0.5\onelineskip
\abovecaptionskip0\onelineskip plus 0.5\onelineskip


%       list of figures, list of tables, and list of listings

\newlistof{listoflistings}{lol}{\listlistingname}

\def\tnt@stdlist@ids{%
    {figure}{Figure}{lof},{table}{Table}{lot},{listing}{Listing}{lol}%
}
\def\tnt@create@stdlists#1#2#3{%
    \expandafter\addtodef\csname listof#1s\endcsname{%
        \clearpage
        \if@tnt@single@spacing@\SingleSpacing\fi
    }{%
        \DoubleSpacing
        \clearpage
    }
    \expandafter\renewcommand\csname list#1name\endcsname{%
        List of #2s%
    }
    \expandafter\renewcommand\csname print#3title\endcsname[1]{%
        \centering
        \textbf{\MakeTextUppercase{##1}}
    }
    \expandafter\renewcommand\csname#3headstart\endcsname{%
        \if@tnt@single@spacing@\LineJump{-0.5}\else\LineJump{-0.25}\fi
        \par
    }
    \expandafter\renewcommand\csname after#3title\endcsname{%
        \if@tnt@single@spacing@\LineJump{2}\else\LineJump{1}\fi
        \par
    }
}

\@for\type:=\tnt@stdlist@ids\do{%
    \edef\@typea{\expandafter\@firstofthree\type}%
    \edef\@typeb{\expandafter\@secondofthree\type}%
    \edef\@typec{\expandafter\@thirdofthree\type}%
    \tnt@create@stdlists\@typea\@typeb\@typec%
}

%   entry specifications in the list of figures
\def\tnt@@cftfigure\numberline#1#2#3{%
    \noindent%
    \makebox[\tnt@std@pgboxwidth][l]{%
        Page #3%
    }%
    \parbox[t]{\dimexpr\textwidth-\tnt@std@pgboxwidth\relax}{%
        Figure #1:\ #2%
    }%
    \vskip1\baselineskip%
}
\def\tnt@cftfigure#1#2{%
    \tnt@@cftfigure#1{#2}%
}
\let\c@figure\c@@Figure
\let\l@figure\tnt@cftfigure
\let\l@@Figure\tnt@cftfigure

%   entry specifications in the list of tables
\def\tnt@@cfttable\numberline#1#2#3{%
    \noindent%
    \makebox[\tnt@std@pgboxwidth][l]{%
        Page #3%
    }%
    \parbox[t]{\dimexpr\textwidth-\tnt@std@pgboxwidth\relax}{%
        Table #1:\ #2%
    }%
    \vskip1\baselineskip%
}
\def\tnt@cfttable#1#2{%
    \tnt@@cfttable#1{#2}%
}
\let\c@table\c@@Table
\let\l@table\tnt@cfttable
\let\l@@Table\tnt@cfttable

%   entry specifications in the list of listings
\def\tnt@@cftlisting\numberline#1#2#3{%
    \noindent%
    \makebox[\tnt@std@pgboxwidth][l]{%
        Page #3%
    }%
    \parbox[t]{\dimexpr\textwidth-\tnt@std@pgboxwidth\relax}{%
        Listing #1:\ #2%
    }%
    \vskip1\baselineskip%
}
\def\tnt@cftlisting#1#2{%
    \tnt@@cftlisting#1{#2}%
}

\let\c@listing\c@@Listing
\let\l@listing\tnt@cftlisting
\let\l@@Listing\tnt@cftlisting


%       user-defined special lists pages

\newcount\tnt@number@spc@lists
    \tnt@number@spc@lists\z@
\def\SpecialListItem#1#2#3{%
    \expandafter\def\csname list#1name\endcsname{List of #3}
    \newlistof{listof#1s}{#2}{\csname list#1name\endcsname}
    \newlistentry{#1}{#2}{0}
    \counterwithout{#1}{chapter}
    \regtotcounter{#1}
    \expandafter\addtodef\csname listof#1s\endcsname{%
        \clearpage
        \if@tnt@single@spacing@\SingleSpacing\fi
    }{%
        \DoubleSpacing
        \clearpage
    }
    \expandafter\renewcommand\csname print#2title\endcsname[1]{%
        \centering
        \textbf{\MakeTextUppercase{##1}S}
    }
    \expandafter\renewcommand\csname #2headstart\endcsname{%
        \if@tnt@single@spacing@\LineJump{-0.5}\else\LineJump{-0.25}\fi
        \par
    }
    \expandafter\renewcommand\csname after#2title\endcsname{%
        \if@tnt@single@spacing@\LineJump{1}\else\LineJump{0.5}\fi
        \par
    }
    \expandafter\newinnerdimen\csname tnt@#1width\endcsname
        \csname tnt@#1width\endcsname5em
    \expandafter\def\csname #1width\endcsname##1{%
        \csname tnt@#1width\endcsname##1
    }
    \expandafter\def\csname tnt@cft#1\endcsname##1##2{%
        \csname tnt@@cft#1\endcsname##1{##2}
    }
    \expandafter\def\csname tnt@@cft#1\endcsname\numberline##1##2##3{%
        \noindent\makebox[\tnt@spc@pgboxwidth][l]{%
            Page ##3%
        }%
        \makebox[\csname tnt@#1width\endcsname][l]{%
            \@firstoftwo##2%
        }%
        \parbox[t]{\dimexpr \textwidth-\tnt@spc@pgboxwidth%
            -\csname tnt@#1width\endcsname\relax}{%
            \phantom{M}%
            \@secondoftwo##2%
        }%
        \vskip1\baselineskip%
    }
    \expandafter\let\csname  l@#1\expandafter\endcsname%
        \csname tnt@cft#1\endcsname
    \expandafter\newcommand\csname#1\endcsname[2][]{%
       \refstepcounter{#1}
       \phantomsection
        \addcontentsline{#2}{#1}{%
            \protect\numberline{\value{#1}}{%
                {##2}{##1}
            }
        }
    }
    \advance\tnt@number@spc@lists\@ne
    \expandafter\def\csname
    tnt@speciallist@\the\tnt@number@spc@lists\endcsname{%
        \ifnum\totvalue{#1}>\z@%
            \phantomsection%
            \addcontentsline{toc}{chapter}{List of #3s}%
            \begingroup
                \renewcommand*{\addcontentsline}[3]{}%
                \csname listof#1s\endcsname
            \endgroup%
        \fi%
    }
}


%       keys for special float environments

\def\tnt@universalkeys{%
    caption,label,shortcaption,postcaption,note,callout%
}

\@for\key:=\tnt@universalkeys\do{%
    \begingroup
        \edef\ukey{%
            \endgroup%
            \noexpand\define@key{float}{\key}{%
                \noexpand\@namedef{tnt@\key}{##1}
            }
        }\ukey
}

\long\def\tnt@@note{%
    \@ifundefined{tnt@note}{}{%
            \vskip0.5\onelineskip%
            \parbox{\textwidth}{%
                \textit{Note}.\space%
                \tnt@note%
            }
    }
}

\long\def\tnt@@callout{%
    \@ifundefined{tnt@callout}{}{%
            \vskip0.5\onelineskip%
            \parbox{\textwidth}{%
                \tnt@callout%
            }
    }
}

\def\tnt@postfloat{%
    \tnt@@note%
    \tnt@@callout%
    \tnt@init@float@keyvalues%
}

\def\tnt@@postcaption{%
    \@ifundefined{tnt@postcaption}{}{%
        \tnt@postcaption%
    }
}

\def\tnt@adjust@listingoptions{%
    \begingroup%
        \edef\nnin{%
            \endgroup%
            \noexpand\in@{numbers=none}{\tnt@listingoptions}%
        }\nnin%
    \ifin@%
        \addtolist{\tnt@listingoptions}{xleftmargin=\z@}%
    \else%
        \addtolist{\tnt@listingoptions}{xleftmargin=\tnt@minted@xleftmargin}%
    \fi%
}

\def\tnt@prefloat#1{%
    \setkeys{float}{#1}%
    \tnt@adjust@listingoptions%
    \@ifundefined{tnt@caption}{%
        \ClassError{TNT}{%
            Every float requires a caption%
        }{}%
    }{%
        \@ifundefined{tnt@shortcaption}{%
            \def\tnt@shortcaption{\tnt@caption}
        }{}%
    }%
    \caption[\tnt@shortcaption]{\tnt@caption\tnt@@postcaption}%
    \@ifundefined{tnt@label}{}{%
        \label{\tnt@label}%
    }%
}


%       \Graphic macro

\def\tnt@graphicsoptions{}

\def\tnt@figurekeys{%
    width,height,totalheight,keepaspectratio,origin,type,ext,page,clip,scale,angle%
}
\@for\key:=\tnt@figurekeys\do{%
    \begingroup
        \edef\fkey{%
            \endgroup%
            \noexpand\define@key{float}{\key}{%
                \noexpand\addtolist{\noexpand\tnt@graphicsoptions}{\key=##1}
            }
        }\fkey
}

\def\tnt@process@graphics#1{%
    \begingroup
        \edef\pg{%
            \endgroup%
            \noexpand\includegraphics\ifx\tnt@graphicsoptions\@empty\else%
                [\tnt@graphicsoptions]\fi{#1}%
        }\pg%
}

\newcommand{\Graphic}[2][]{%
    \@Figure%
        \tnt@prefloat{#1}%
        \tnt@process@graphics{#2}%
        \tnt@postfloat%
    \end@Figure%
}

\let\oldfigure\figure
\def\figure{%
    \oldfigure%
    \ClassWarning{TNT}{%
        It is strongly advised to use the \protect\Graphic\space macro\MessageBreak
        instead of the standard ``figure'' environment to get the\MessageBreak
        positioning of the figure and caption correct. See the\MessageBreak
        user's manual for details%
    }
}


%       \Table macro

\define@key{float}{env}{%
    \def\tnt@env{#1}%
}

\define@key{float}{colspecs}{%
    \def\tnt@colspecs{#1}
}

\newif\if@tnt@compress@
    \@tnt@compress@false
\define@key{float}{compress}[true]{%
    \global\csname @tnt@compress@#1\endcsname
}

\define@key{float}{tabwidth}{%
    \def\tnt@tabwidth{#1}
}
\def\tnt@@tabwidth{%
    \@ifundefined{tnt@tabwidth}{}{%
        {\tnt@tabwidth}
    }
}

\def\tnt@table@compress#1#2#3{%
    \resizebox{\textwidth}{!}{%
        \begingroup%
            \edef\x{%
                \endgroup%
                \noexpand\begin{#1}{#2}%
            }\x%
                #3%
        \begingroup%
            \edef\y{%
                \endgroup%
                \noexpand\end{#1}%
            }\y%
    }%
}

\def\tnt@table@standard#1#2#3{%
    \setbox0\vbox{%
        \begingroup%
            \edef\s{%
                \endgroup%
                \noexpand\begin{#1}\tnt@@tabwidth{#2}%
            }\s%
            #3%
        \begingroup%
            \edef\w{%
                \endgroup%
                \noexpand\end{#1}%
            }\w%
    }\unvbox0%
}

\newcommand{\Table}[2][]{%
    \@Table%
        \tnt@prefloat{#1}%
        \if@tnt@compress@%
            \tnt@table@compress{\tnt@env}{\tnt@colspecs}{#2}%
        \else%
            \tnt@table@standard{\tnt@env}{\tnt@colspecs}{#2}%
        \fi%
        \tnt@postfloat%
    \end@Table%
}

\let\oldtable\table
\def\table{%
    \oldtable%
    \ClassWarning{TNT}{%
        It is strongly advised to use the ``Table'' macro\MessageBreak
        instead of the standard ``table'' environment to get the\MessageBreak
        positioning of the table and caption correct. See the\MessageBreak
        user's manual for details%
    }
}


%       Listing environment

\def\tnt@listingoptions{}

\def\tnt@std@listingkeys{%
    baselinestretch,breakafter,breakaftersymbolpre,breakaftersymbolpost,%
    breakanywheresymbolpre,breakanywheresymbolpost,breakbefore,%
    breakbeforesymbolpre,breakbeforesymbolpost,breakindent,breakindentchars,%
    breaksymbolleft,breaksymbolright,breaksymbolsepleft,breaksymbolsepright,%
    breaksymbolindentleft,breaksymbolindentright,breaksymbol,breaksymbolsep,%
    breaksymbolindent,breaksymbolindentleftnchars,breaksymbolindentnchars,%
    breaksymbolindentrightnchars,breaksymbolsepnchars, breaksymbolsepleftnchars,%
    breaksymbolseprightnchars,bgcolor,codetagify,encoding,escapeinside,firstline,%
    firstnumber,fontfamily,fontseries,fontsize,fontshape,formatcom,frame,framerule,%
    framesep,gobble,highlightcolor,highlightlines,keywordcase,lastline,numbers,%
    numbersep,outencoding,rulecolor,space,spacecolor,style,stepnumber,tab,%
    tabcolor,tabsize,xleftmargin,xrightmargin%
}
\@for\key:=\tnt@std@listingkeys\do{%
    \begingroup
        \edef\ckey{%
            \endgroup%
            \noexpand\define@key{float}{\key}{%
                \noexpand\addtolist{\noexpand\tnt@listingoptions}{\key=##1}
            }
        }\ckey
}
\def\tnt@bool@listingkeys{%
    autogobble,beameroverlays,breakaftergroup,%
    breakanywhere,breakautoindent,breakbeforegroup,breakbytoken,%
    breakbytokenanywhere,breaklines,curlyquotes,funcnamehighlighting,linenos,%
    numberfirstline,mathescape,numberblanklines,obeytabs,python3,%
    resetmargins,samepage,showspaces,showtabs,startinline,stepnumberfromfirst,%
    stepnumberoffsetvalues,stripall,stripnl,texcl,texcomments%
}
\@for\key:=\tnt@bool@listingkeys\do{%
    \begingroup
        \edef\bkey{%
            \endgroup%
            \noexpand\define@key{float}{\key}[true]{%
                \noexpand\addtolist{\noexpand\tnt@listingoptions}{\key=##1}
            }
        }\bkey
}

\def\tnt@prelisting#1#2{%
        \VerbatimEnvironment%
        \let\FVB@VerbatimOut\minted@FVB@VerbatimOut%
        \let\FVE@VerbatimOut\minted@FVE@VerbatimOut%
        \minted@configlang{#2}%
        \begingroup%
        \edef\skm{%
            \endgroup%
            \noexpand\setkeys{minted@opt@cmd}{#1}%
        }\skm%
        \minted@fvset%
        \begin{VerbatimOut}[codes={\catcode`\^^I=12},firstline,lastline]%
            {\minted@jobname.pyg}%
}
\def\tnt@postlisting{%
    \end{VerbatimOut}%
    \minted@langlinenoson%
    \minted@pygmentize{\minted@lang}%
    \minted@langlinenosoff%
}

\renewcommand{\theFancyVerbLine}{%
    \tnt@minted@numberfont{\arabic{FancyVerbLine}}%
}
\definecolor{codegray}{rgb}{0.97,0.97,0.97}

\newenvironment{Listing}[2][]
{%
    \@Listing%
        \tnt@prefloat{#1}%
        \tnt@prelisting{\tnt@listingoptions}{#2}%
}
{%
        \tnt@postlisting%
        \tnt@postfloat%
    \end@Listing%
}

\AtBeginDocument{%
    \let\oldlisting\listing
    \def\listing{%
        \oldlisting%
        \ClassWarning{TNT}{%
            It is strongly advised to use the ``Listing'' environment\MessageBreak
            instead of the ``listing'' environment to get the\MessageBreak
            positioning of the table and caption correct. See the\MessageBreak
            user's manual for details%
        }
    }
    \def\lstlisting{%
        \ClassError{TNT}{%
            You *must* use the (provided) ``minted'' package and *not* the\MessageBreak
            ``listings'' package to display code. See the user's manual for\MessageBreak
            more details%
        }{}
    }
}


%       defaults for floats

\newdimen\tnt@minted@xleftmargin

\define@key{float}{finalline}{%
    \begingroup
        \setbox0\hbox{%
            \tnt@minted@numberfont{#1}%
        }
        \global\tnt@minted@xleftmargin%
            \dimexpr\tnt@minted@numbersep+\wd0\relax%
    \endgroup
}

\def\tnt@default@float@keyvalues{%
    width=\textwidth, totalheight=\textheight, keepaspectratio=true,%
    env=tabular, compress=false,%
    breaklines=true, breakindent=3em, numbers=left, finalline=9,%
    numbersep=\tnt@minted@numbersep, xleftmargin=\tnt@minted@xleftmargin,%
    frame=lines, framesep=2ex, numberfirstline=true, style=xcode%
}

\def\tnt@init@float@keyvalues{%
    \gdef\tnt@graphicsoptions{}%
    \gdef\tnt@listingoptions{}%
    \begingroup%
        \edef\skf{%
            \endgroup%
            \noexpand\setkeys{float}{\tnt@default@float@keyvalues}%
        }\skf%
}

\newcommand{\GlobalFloatParameters}[1]{%
    \gdef\tnt@default@float@keyvalues{#1}
}

\AtBeginDocument{%
    \tnt@init@float@keyvalues
}


%       chapter and friends style

\makechapterstyle{tech}{%
    \beforechapskip\tnt@chapskip
    \midchapskip\tnt@chapskip
    \afterchapskip\baselineskip
    \renewcommand*{\printchaptername}{%
        \chapnamefont%
        \MakeTextUppercase{\chaptername}%
    }
    \renewcommand*{\chapnamefont}{%
        \centering%
        \bfseries%
        \boldmath%
    }
    \renewcommand*{\chapnumfont}{\chapnamefont}
    \renewcommand*{\printchapternum}{%
        \chapnumfont%
        \thechapter%
    }
    \renewcommand*{\printchaptertitle}[1]{%
        \chaptitlefont%
        \MakeTextUppercase{##1}%
    }
    \renewcommand*{\chaptitlefont}{%
        \centering%
        \bfseries%
        \boldmath%
    }
}

\setsecheadstyle{%
    \centering%
    \bfseries%
    \boldmath%
}
\setbeforesecskip{\tnt@secbeforeskip}
\setaftersecskip{\tnt@secafterskip}

\setsubsecheadstyle{%
    \raggedright%
    \bfseries%
    \boldmath%
}
\setbeforesubsecskip{\tnt@secbeforeskip}
\setaftersubsecskip{\tnt@secafterskip}

\setsubsubsecheadstyle{%
    \raggedright%
    \bfseries%
    \boldmath%
    \itshape%
}
\setbeforesubsubsecskip{\tnt@secbeforeskip}
\setaftersubsubsecskip{\tnt@secafterskip}


%       bibliography/citation style

\RequirePackage[style=apa, backend=biber, citestyle=numeric-comp,
language=american, defernumbers=true]{biblatex}

\DeclareLanguageMapping{american}{american-apa}
\DeclareBibliographyCategory{cited}
\def\ifcategoryempty#1{\ifcsvoid{blx@catg@#1}}

\AtBeginDocument{%
    \@ifundefined{tnt@bibreferences}{%
        \ClassError{TNT}{%
            Your bibliography file must be provided through\MessageBreak
            the \protect\MyBibReferences\space macro%
        }{}
    }{}
    \AtEveryCitekey{%
            \addtocategory{cited}{\thefield{entrykey}}%
    }%
    \DeclareFieldFormat{labelnumberwidth}{\mkbibbrackets{#1}}
    \defbibenvironment{bibliography}%
    {\list
        {%
            \printtext[labelnumberwidth]{%
                \printfield{labelprefix}%
                \printfield{labelnumber}%
            }
        }%
        {%
            \setlength{\labelwidth}{\tnt@labelwidth}
            \setlength{\leftmargin}{\labelwidth}%
            \setlength{\labelsep}{\biblabelsep}%
                \addtolength{\leftmargin}{\labelsep}%
            \setlength{\itemsep}{\bibitemsep}%
            \setlength{\parsep}{\bibparsep}%
        }%
        \renewcommand*{\makelabel}[1]{\hss##1}%
    }%
    {\endlist}%
    {%
        \item%
    }
}
\renewcommand{\bibname}{REFERENCES}
\defbibheading{bibliography}[\bibname]{%
    \chapter*{#1}%
}

\long\def\tnt@referencessection{%
    \cleardoublepage
    \phantomsection
    \addcontentsline{toc}{chapter}{References}
    \@ifundefined{tnt@bibreferences}{%
        \begin{center}
            \textbf{REFERENCES}
        \end{center}
        \LineJump{1}
        \textlangle\textlangle References Not Provided\textrangle\textrangle
    }{%
        \ifcategoryempty{cited}{%
            \begin{center}
                \textbf{REFERENCES}
            \end{center}
            \LineJump{1}
            \textlangle\textlangle References Not Cited\textrangle\textrangle
        }{%
            \begingroup
            \renewcommand*{\addcontentsline}[3]{}
            \bibitemsep\onelineskip
            \begin{SingleSpace}
                \printbibliography[%
                    category={cited},%
                    title={REFERENCES}
                ]
            \end{SingleSpace}
            \endgroup
        }
    }
    \clearpage
}


%       vita page

\long\def\tnt@vitapage{%
    \cleartorecto
    \phantomsection
    \addcontentsline{toc}{chapter}{Vita}
    \begin{center}
        \textbf{VITA}
    \end{center}
    \LineJump{1}
    \begin{minipage}{6in}
        \parindent\tnt@parindent
        \tnt@vita
    \end{minipage}
    \clearpage
}


%       frontmatter, mainmatter, backmatter specifications

\long\def\frontmattercontent{%
    \pagenumbering{roman}
    \setcounter{page}{1}
    \tnt@titlepage
    \pagestyle{plain}
    \tnt@abstractpage
    \tnt@copyrightpage
    \tableofcontents*
    \tnt@approvalpage
    \@ifundefined{tnt@dedication}{}{\tnt@dedicationpage}
    \@ifundefined{tnt@acknowledgment}{}{\tnt@acknowledgmentspage}
    \ifnum\totvalue{figure}>\z@
        \phantomsection
        \addcontentsline{toc}{chapter}{List of Figures}
        \begingroup
            \renewcommand*{\addcontentsline}[3]{}
            \listoffigures
        \endgroup
    \fi
    \ifnum\totvalue{table}>\z@
        \phantomsection
        \addcontentsline{toc}{chapter}{List of Tables}
        \begingroup
            \renewcommand*{\addcontentsline}[3]{}
            \listoftables
        \endgroup
    \fi
    \ifnum\totvalue{listing}>\z@
        \phantomsection
        \addcontentsline{toc}{chapter}{List of Listings}
        \begingroup
            \renewcommand*{\addcontentsline}[3]{}
            \listoflistings
        \endgroup
    \fi
    \count@\@ne
    \loop
        \ifnum\count@>\tnt@number@spc@lists\else%
            \csname tnt@speciallist@\the\count@\endcsname%
            \advance\count@\@ne
    \repeat
}

\long\def\mainmattercontent{%
    \pagestyle{tech}
    \chapterstyle{tech}
    \parindent\tnt@parindent
    \justifying
    \indentafterchapter
    \ifnum\tnt@totalnumber@chapters=\z@
        \csname tnt@mychapter0\endcsname
    \else
        \begingroup
        \count@\@ne
        \loop
            \ifnum\count@>\tnt@totalnumber@chapters\else
                \csname tnt@mychapter\the\count@\endcsname
                \advance\count@\@ne
        \repeat
        \endgroup
    \fi
}

\long\def\backmattercontent{%
    \renewcommand*{\chaptername}{Appendix}
    \appendix
    \parindent\tnt@parindent
    \justifying
    \begingroup
    \@tempcntb\@ne
    \loop
        \ifnum\@tempcntb>\tnt@totalnumber@appendices\else
            \csname tnt@myappendix\the\@tempcntb\endcsname
            \advance\@tempcntb\@ne
    \repeat
    \endgroup
    \tnt@referencessection
    \tnt@vitapage
}

\newcommand{\ThesisContent}{%
    \begin{document}
        \frontmattercontent
        \mainmatter
        \mainmattercontent
        \backmattercontent
    \end{document}
}


%       theorem specifications

\g@addto@macro\normalsize{%
    \abovedisplayskip\tnt@displayaboveskip%
    \belowdisplayskip\tnt@displaybelowskip%
    \abovedisplayshortskip\tnt@displayshortaboveskip%
    \belowdisplayshortskip\tnt@displayshortbelowskip%
}

\declaretheoremstyle[spaceabove=\tnt@abovethm,
    spacebelow=\tnt@belowthm,
    headfont=\normalfont\bfseries, headindent=0pt,
    headpunct={}, notefont=\mdseries,
    headformat={\NAME\ \NUMBER.\NOTE},
    notebraces={(}{)}, bodyfont=\normalfont\itshape,
    postheadspace=0.5em]{tntthmstyle}

\declaretheoremstyle[spaceabove=\tnt@abovethm,
    spacebelow=\tnt@belowthm,
    headfont=\normalfont\bfseries, headindent=0pt,
    headpunct={}, notefont=\mdseries,
    headformat={\NAME\ \NUMBER.\NOTE},
    notebraces={(}{)}, bodyfont=\normalfont,
    postheadspace=0.5em]{tntdefstyle}

\declaretheoremstyle[spaceabove=\tnt@abovethm,
    spacebelow=\tnt@belowthm,
    headfont=\normalfont\itshape, headindent=0pt,
    headpunct={}, notefont=\mdseries,
    headformat={\NAME\ \NUMBER.\NOTE},
    notebraces={(}{)}, bodyfont=\normalfont,
    postheadspace=0.5em]{tntremstyle}

\declaretheoremstyle[spaceabove=\tnt@abovethm,
    spacebelow=\tnt@belowthm,
    headfont=\normalfont\itshape, headindent=0pt,
    headpunct={}, notefont=\mdseries,
    headformat={\NAME. \NOTE},
    notebraces={(}{)}, bodyfont=\normalfont,
    postheadspace=0.5em]{tntconjstyle}

\declaretheorem[name=Theorem,
    refname={theorem, theorems},
    Refname={Theorem, Theorems},
    numberwithin=section,
    style=tntthmstyle]{theorem}

\declaretheorem[name=Lemma,
    refname={lemma, lemmas},
    Refname={Lemma, Lemmas},
    sibling=theorem,
    style=tntthmstyle]{lemma}

\declaretheorem[name=Corollary,
    refname={corollary, corollaries},
    Refname={Corollary, Corollaries},
    sibling=theorem,
    style=tntthmstyle]{corollary}

\declaretheorem[name=Proposition,
    refname={proposition, propositions},
    Refname={Proposition, Propositions},
    sibling=theorem,
    style=tntthmstyle]{proposition}

\declaretheorem[name=Definition,
    refname={definition, definitions},
    Refname={Definition, Definitions},
    sibling=theorem,
    style=tntdefstyle]{definition}

\declaretheorem[name=Example,
    refname={example, examples},
    Refname={Example, Examples},
    sibling=theorem,
    style=tntdefstyle]{example}

\declaretheorem[name=Fact,
    refname={fact, facts}, Refname={Fact, Facts},
    sibling=theorem, style=tntdefstyle]{fact}

\declaretheorem[name=Remark,
    refname={remark, remarks},
    Refname={Remark, Remarks},
    sibling=theorem,
    style=tntremstyle]{remark}

\declaretheorem[name=Conjecture,
    refname={conjecture, conjectures},
    Refname={Conjecture, Conjectures},
    numbered=no,
    style=tntconjstyle]{conjecture}

\declaretheorem[name=Question,
    refname={question, questions},
    Refname={Question, Questions},
    numbered=no,
    style=tntconjstyle]{question}

\declaretheorem[name=Problem,
    refname={problem, problems},
    Refname={Problem, Problems},
    numbered=no,
    style=tntconjstyle]{problem}

\declaretheorem[name=Hypothesis,
    refname={hypothesis, hypotheses},
    Refname={Hypothesis, Hypotheses},
    numbered=no,
    style=tntconjstyle]{hypothesis}

\declaretheorem[name=Conclusion,
    refname={conclusion, conclusions},
    Refname={Conclusion, Conclusions},
    numbered=no,
    style=tntconjstyle]{conclusion}

\declaretheorem[name=Methodology,
    refname={methodology, methodologies},
    Refname={Methodology, Methodologies},
    numbered=no,
    style=tntconjstyle]{methodology}


%       proof specification

\newif\if@tnt@markproof@
    \global\@tnt@markproof@false
\newcommand*{\QEDhere}{%
    \hskip1em plus1em minus1em \hbox{\mathqed}

    \let\oldendalign\endalign
        \def\endalign{\oldendalign \vskip1ex plus 1ex}

    \let\oldendalignat\endalignat
        \def\endalignat{\oldendalignat \vskip1ex plus 1ex}

    \let\oldendaligned\endaligned
        \def\endaligned{\oldendaligned \vskip1ex plus 1ex}

    \let\oldendgather\endgather
        \def\endgather{\oldendgather \vskip1ex plus 1ex}

    \let\oldendmultline\endmultline
        \def\endmultline{\oldendmultline \vskip1ex plus 1ex}

    \let\oldendsplit\endsplit
        \def\endsplit{\oldendsplit \vskip1ex plus 1ex}

    \let\oldenddisplaymath\enddisplaymath
        \def\enddisplaymath{\oldenddisplaymath \vskip1ex plus 1ex}

    \let\oldendequation\endequation
        \def\endequation{\oldendequation \vskip1ex plus 1ex}

    \let\oldenddspmth\]
        \def\]{\oldenddspmth \vskip1ex plus 1ex}

    \global\@tnt@markproof@true
}

\renewenvironment{proof}%
    {%
        \noindent\textbf{Proof.}\thickspace%
    }
    {%
        \if@tnt@markproof@
            \global\@tnt@markproof@false
            \let\endalign\oldendalign
            \let\endalignat\oldendalignat
            \let\endaligned\oldendaligned
            \let\endgather\oldendgather
            \let\endmultline\oldendmultline
            \let\endsplit\oldendsplit
            \let\enddisplaymath\oldenddisplaymath
            \let\endequation\oldendequation
            \let\]\oldenddspmth
        \else
            \hskip1em plus1em minus1em \hbox{\qedsymbol} \vskip1ex plus 1ex
        \fi
    }


%       special sizing macro

\def\SuperSize#1#2{%
    \setbox0\hbox{\Bigg#2}
    \@tempdimb#1\ht0
    \@tempdimc#1\dp0
    \@tempdima\dimexpr\@tempdimb+\@tempdimc\relax
    \raisebox{-0.5\@tempdimc}{%
        \resizebox*{\wd0}{\@tempdima}{#2}
    }
}


\endinput

%   End of file `TNThesis.cls'
